import { StarXpandCommand } from "star-io10-web";

export class LabelSample10_For203dpiAnd300dpi_FoodDeliveryLabel_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(3, 3),
                )
                .actionPrintText("${store_name}\n")
                .add(
                  new StarXpandCommand.PrinterBuilder()
                    .styleInvert(true)
                    .actionPrintText("${order_name}\n"),
                ),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText("Placed at ${time}\n")
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleUnderLine(true)
                .actionPrintText(
                  "                                                \n",
                ),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${order_types}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleUnderLine(true)
                .actionPrintText(
                  "                                                \n",
                ),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    40,
                    new StarXpandCommand.Printer.TextWidthParameter().setEllipsizeType(
                      StarXpandCommand.Printer.TextEllipsizeType.End,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list.price%.2f}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    8,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintText(
              "------------------------------------------------\n" + "Subtotal",
            )
            .actionPrintText(
              "${subtotal%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                40,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("Amount paid")
            .actionPrintText(
              "${amount_paid%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                37,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "item ${item_count}",
              new StarXpandCommand.Printer.TextParameter().setWidth(10),
            )
            .actionPrintText(
              "${item_price%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                38,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "------------------------------------------------\n",
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("${note}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Star Eats",
    "order_name" : "8A720  Micronics",
    "time" : "March 24 2021 1:30PM",
    "order_types" : "DELIVERY",
    "item_list" : [
        {
            "name" : "1XStar's lunch box A *",
            "price" : 10.95
        }
    ],
    "subtotal" : 0.97,
    "amount_paid" : 11.92,
    "item_count" : 1,
    "item_price" : 10.00,
    "note" : "*Use special sauce as you like!"
}`,
    );
  }
}
